#!/bin/bash
# This script gets three variables passed: $DOMAIN, $ADMIN_PASSWORD and $IP

sudo apt -y install php php-cgi php-mysqli php-pear php-mbstring php-common php-phpseclib php-mysql mariadb-server mariadb-client php-fpm -y



wget https://www.phpmyadmin.net/downloads/phpMyAdmin-latest-all-languages.tar.gz
sudo mkdir /var/www/phpmyadmin

sudo tar -xvf phpMyAdmin-latest-all-languages.tar.gz -C /var/www/phpmyadmin --strip-components=1
rm phpMyAdmin-latest-all-languages.tar.gz

sudo chown -R www-data:www-data /var/www/phpmyadmin
ln -s /var/www/phpmyadmin/ /root/phpmyadmin


# Set the root password for mysql
sudo mysql <<EOF
ALTER USER 'root'@'localhost' IDENTIFIED BY '$ADMIN_PASSWORD';
EOF




echo "portal.$DOMAIN:3000 {
  #tls internal
  root * /var/www/phpmyadmin
  file_server
  php_fastcgi unix//run/php/php-fpm.sock
  encode zstd gzip
  header {
    Strict-Transport-Security max-age=31536000;
    X-Content-Type-Options nosniff
    X-Frame-Options DENY
    Referrer-Policy no-referrer-when-downgrade
    X-XSS-Protection 1; mode=block
  }
}

" >> /etc/caddy/Caddyfile

# If domain is "int.de" uncomment the tls internal line for internal https
if [ "$DOMAIN" = "int.de" ]; then
    sed -i 's/#tls internal/tls internal/g' /etc/caddy/Caddyfile
fi

systemctl restart caddy

# YOU CAN ACCESS PHPMYADMIN VIA portal.$DOMAIN:3000
# (The Port 3000 is not enabled by default in the firewall)