#!/bin/bash

mkdir -p /root/paperlessngx
cp docker-compose.yml /root/paperlessngx/

secret_key=$(openssl rand -hex 32)

# Write docker-compose.env file
echo "
# Map to www-data
USERMAP_UID=33
USERMAP_GID=33
PAPERLESS_URL=https://paper.$DOMAIN
PAPERLESS_SECRET_KEY=$secret_key
PAPERLESS_TIME_ZONE=Europe/Berlin
PAPERLESS_OCR_LANGUAGE=deu
PAPERLESS_OCR_LANGUAGES=eng
PAPERLESS_ADMIN_USER=Administrator
PAPERLESS_ADMIN_PASSWORD=$ADMIN_PASSWORD
" > /root/paperlessngx/docker-compose.env

docker-compose -f /root/paperlessngx/docker-compose.yml up -d

echo "paper.$DOMAIN {
    #tls internal
    reverse_proxy localhost:13125
}

" >> /etc/caddy/Caddyfile

# If domain is "int.de" uncomment the tls internal line for internal https
if [ "$DOMAIN" = "int.de" ]; then
    sed -i 's/#tls internal/tls internal/g' /etc/caddy/Caddyfile
fi

systemctl reload caddy