#!/bin/bash
# This script gets these variables passed: $DOMAIN, $ADMIN_PASSWORD, $IP, $LDAP_DC
mkdir -p /root/anythingllm
# Dont forget to escape " with a backslash:
cp docker-compose.yml /root/anythingllm/docker-compose.yml
mkdir -p /root/anythingllm/volumes
touch /root/anythingllm/volumes/storage/.env

chown -R 1000:1000 /root/anythingllm/volumes

# Envsubst is used to replace variables in the docker-compose.yml file
export DOMAIN=$DOMAIN
export ADMIN_PASSWORD=$ADMIN_PASSWORD
export IP=$IP
export LDAP_DC=$LDAP_DC
envsubst < docker-compose.yml > /root/anythingllm/docker-compose.yml

docker compose -f /root/anythingllm/docker-compose.yml up -d

sleep 15

docker compose -f /root/anythingllm/docker-compose.yml exec -it ollama ollama pull llama2

echo "anythingllm.$DOMAIN {
    #tls internal
    reverse_proxy localhost:36413
}

" >> /etc/caddy/Caddyfile

# If domain is "int.de" uncomment the tls internal line for internal https
if [ "$DOMAIN" = "int.de" ]; then
    sed -i 's/#tls internal/tls internal/g' /etc/caddy/Caddyfile
fi

systemctl restart caddy


# Then in anythingllm:
# Ollama base url is http://ollama:11434
# Keep the Auth token empty
# Finish the setup in the AnythingLLM UI and we are done!